/** @file   MinigunBullet.cpp
 * @brief   Implementation of MinigunBullet class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/08 21:47:24 $
 * @author  Tomi Lamminsaari
 */

#include "MinigunBullet.h"
#include "GfxManager.h"
#include "www_map.h"
#include "gfxid.h"
using namespace eng2d;


namespace WeWantWar {

///
/// Constants, datatypes and static methods
/// ============================================================================




///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
MinigunBullet::MinigunBullet( GameObject* aShooter, const Vec2D& aPos ) :
  Bullet( aShooter, Bullet::EMinigun, aPos )
{
}



/** Destructor.
 */
MinigunBullet::~MinigunBullet()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

/** Draws this bullet.
 */
void MinigunBullet::redraw( BITMAP* aBitmap ) const
{
  int posX = iPosition.intX() - Map::scrollX;
  int posY = iPosition.intY() - Map::scrollY;
  
  BITMAP* gfx = GfxManager::findBitmap( GfxId::KBulletMinigun );
  posX -= gfx->w / 2;
  posY -= gfx->h / 2;
  rotate_sprite( aBitmap, gfx, posX, posY, itofix(iRotation) );
}

};  // end of namespace
